function [] = REVS_init_structures()
%REVS_INIT_STRUCTURES initializes structures with init_functions that need
%to be called before the model can run.

vars = evalin('base','who;');

for i = 1:length(vars)     
    handle_var(vars{i});
end

    function [] = handle_var( varname )
        % fprintf('varname = %s\n',varname);
        if (evalin('base',['max(size(' varname '))']) == 1) && evalin('base',['isstruct(' varname ')'])
            % loop over fields, finding numeric entries...
            fnames = fieldnames(evalin('base',varname));
            for f = 1:length(fnames)
                handle_var([varname '.' fnames{f}]);
            end
            if evalin('base',['isfield(' varname ',''init_function'')'])
                evalin('base',[varname ' = evalin(''base'',[' varname '.init_function ''(' varname ', REVS.verbose )'']);'])
            end
        end
    end

end
